﻿using Helper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace ZSMusic.Model
{
    //[Category("基本属性")]
    //[DisplayName("公司名称")]
    //[Description("公司名称")]
    [Serializable]
    public class Music
    {
        [Category("主键")]
        [DisplayName("歌曲编号")]
        [Description("修改此项可能导致异常")]
        //[BrowsableAttribute(false)]
        public string Id { get; set; }

        [Category("基本属性")]
        [DisplayName("曲名")]
        [Description("曲名")]
        public string Name { get; set; }

        [Category("基本属性")]
        [DisplayName("艺术家")]
        [Description("艺术家")]
        public string Artist { get; set; }

        [Category("基本属性")]
        [DisplayName("专辑")]
        [Description("专辑")]
        public string Album { get; set; }

        [Category("基本属性")]
        [DisplayName("专辑编号")]
        [Description("专辑编号")]
        public string AlbumId { get; set; }

        [Category("基本属性")]
        [DisplayName("来源")]
        [Description("音乐源")]
        public string Source { get; set; }

        [Category("扩展属性")]
        [DisplayName("播放地址")]
        [Description("播放地址")]
        public string Url { get; set; }

        [Category("扩展属性")]
        [DisplayName("图片地址")]
        [Description("图片地址")]
        public string PicUrl { get; set; }

        [Category("扩展属性")]
        [DisplayName("动态歌词")]
        [Description("动态歌词")]
        public string Lrc { get; set; }

        [Category("自定义属性")]
        [Description("与对象关联的用户定义数据")]
        public object Tag { get; set; }

        public Music() { }

        public Music(string id)
        {
            // TODO: Complete member initialization
            this.Id = id;
        }
        /// <summary>
        /// 比较两首歌信息的相似度
        /// </summary>
        /// <param name="s">要比较的歌曲</param>
        /// <returns></returns>
        public double SimilarWith(Music s)
        {
            try
            {
                string name = Regex.Replace(this.Name.ToLower().Replace(" ", ""), "-《.*", "");
                string targetName = Regex.Replace(s.Name.ToLower().Replace(" ", ""), "-《.*", "");
                string artist = this.Artist.ToLower().Replace(" ", "");
                string targetArtist = s.Artist.ToLower().Replace(" ", "");
                if (name == targetName && artist == targetArtist)
                { return 1; }
                //	你的眼睛-《在一起》电视剧插曲
                //if (StringEx.GetSimilarityWith(name, targetName) < 0.9) { return 0; }
                return StringEx.GetSimilarityWith(name + artist, targetName + targetArtist);

            }
            catch (Exception)
            {
                return 0;
            }

        }

        public override bool Equals(object obj)
        {
            if (obj != null)
                return SimilarWith(obj as Music) == 1.0;
            else { return false; }
        }
        /// <summary>
        /// 输出格式
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            Artist = StringEx.RemoveInvalidFile(Artist);
            Name = StringEx.RemoveInvalidFile(Name);
            Album = StringEx.RemoveInvalidFile(Album);
            Name = ConvertEx.SignToEnglish(Name);
            Artist = ConvertEx.SignToEnglish(Artist).Replace("/",",").Replace("&",",");
            if (Album != null)
            {
                Album = ConvertEx.SignToEnglish(Album);
            }
            return string.Format("{0} - {1}", Artist, Name);
        }


        public bool IsVideo()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 从DataRow中获取实体
        /// </summary>
        /// <param name="row">行</param>
        /// <returns></returns>
        public static Music FromRow(DataRow row)
        {
            ModelConvertHelper<Music> h = new ModelConvertHelper<Music>();
            return h.Row2Model<Music>(row);
        }

        /// <summary>
        /// 实体集合转DataTable
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public static DataTable ModelToTable(List<Music> list)
        {
            ModelConvertHelper<Music> h = new ModelConvertHelper<Music>();
            return h.ListToDataTable(list);
        }
        /// <summary>
        /// DataTable转实体集合
        /// </summary>
        /// <param name="dt"></param>
        /// <returns></returns>
        public static List<Music> TableToModel(DataTable dt)
        {
            ModelConvertHelper<Music> h = new ModelConvertHelper<Music>();
            return ModelConvertHelper<Music>.DataTableToList(dt);
        }

    }
}
